/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.ekb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.ParamConverter;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.ekb.interfaces.ILinkWeightComputer;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarityComputer;
import ru.ispras.texterra.core.rest.converters.LinkWeightComputerConverter;
import ru.ispras.texterra.core.rest.ekb.ConceptsSimilarityResource;
import ru.ispras.texterra.core.rest.extractors.ConceptPathMatrixParamExtractor;

@Path(value="")
public class SimilarityResource {
    private static final ParamConverter<ILinkWeightComputer> LINK_WEIGHT_CONVERTER = new LinkWeightComputerConverter().getConverter(ILinkWeightComputer.class, (Type)((Object)ILinkWeightComputer.class), new Annotation[0]);
    private final ISimilarityComputer similarityComputer;

    public SimilarityResource(ISimilarityComputer similarityComputer) {
        this.similarityComputer = similarityComputer;
    }

    @Path(value="{concepts}")
    public ConceptsSimilarityResource getConceptsSimilarityResource(@PathParam(value="concepts") PathSegment conceptsAndLinkWeight) {
        String linkWeightComputerParam = (String)conceptsAndLinkWeight.getMatrixParameters().getFirst((Object)"linkWeight");
        ILinkWeightComputer linkWeightComputer = (ILinkWeightComputer)LINK_WEIGHT_CONVERTER.fromString(linkWeightComputerParam);
        List<Concept> concepts = new ConceptPathMatrixParamExtractor().getConcepts(conceptsAndLinkWeight);
        return new ConceptsSimilarityResource(this.similarityComputer, concepts, linkWeightComputer);
    }
}

