/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.ekb;

import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.PathSegment;
import ru.ispras.texterra.core.ekb.interfaces.IKBWalker;
import ru.ispras.texterra.core.rest.ekb.ConceptResource;
import ru.ispras.texterra.core.rest.extractors.ConceptPathMatrixParamExtractor;

@Path(value="")
public class KBWalkerResource {
    private final IKBWalker kbWalker;

    public KBWalkerResource(IKBWalker kbWalker) {
        this.kbWalker = kbWalker;
    }

    @GET
    public String printUsage() {
        return "Please choose KB walker method.";
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="kbnames")
    public Set<String> getKbNames() {
        return this.kbWalker.getKbNames();
    }

    @Path(value="{concept}")
    public ConceptResource selectConcepts(@PathParam(value="concept") PathSegment conceptSegment) {
        return new ConceptResource(this.kbWalker, new ConceptPathMatrixParamExtractor().getConcepts(conceptSegment));
    }
}

