/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.cli.nlp.DefaultPipelineSpecification;
import ru.ispras.texterra.tools.nlp.ITexterraNLP;

public class PipelineSpecificationConverter
implements ParamConverterProvider {
    private static final Pattern PATTERN = Pattern.compile("([a-zA-Z0-9._]+)(?:\\((.+)\\))?");

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!ITexterraNLP.PipelineSpecification.class.equals(rawType)) {
            return null;
        }
        return new ParamConverter<T>(){

            public T fromString(String value) {
                Matcher matcher = PATTERN.matcher(value);
                Validate.isTrue((boolean)matcher.matches(), (String)"Cannot convert given string: %s to pipeline spec", (Object[])new Object[]{value});
                String name = matcher.group(1);
                String param = matcher.group(2);
                return rawType.cast(DefaultPipelineSpecification.valueOf(name.toUpperCase()).createPipelineSpec(Optional.ofNullable(param)));
            }

            public String toString(T value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

