/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.commons.lang.StringUtils;

public class MatrixParamExtractor<T> {
    private final ParamConverter<T> converter;
    private final String paramName;

    public MatrixParamExtractor(String paramName, ParamConverterProvider provider, Class<T> extractedClass) {
        this.converter = provider.getConverter(extractedClass, extractedClass, extractedClass.getAnnotations());
        this.paramName = paramName;
    }

    public MatrixParamExtractor(String paramName, ParamConverter<T> converter) {
        this.converter = converter;
        this.paramName = paramName;
    }

    public List<T> extract(PathSegment pathSegment) {
        List values = (List)pathSegment.getMatrixParameters().get((Object)this.paramName);
        ArrayList<Object> result = new ArrayList<Object>();
        if (values != null) {
            for (String param : values) {
                result.add(this.converter.fromString(param));
            }
        }
        return result;
    }

    public PathSegment construct(List<T> elements) {
        MultivaluedHashMap params = new MultivaluedHashMap();
        ArrayList<String> pathElements = new ArrayList<String>();
        for (T element : elements) {
            String value = this.converter.toString(element);
            params.add((Object)this.paramName, (Object)value);
            pathElements.add(new String(this.paramName + "=" + value));
        }
        return new DummyPathSegment(StringUtils.join(pathElements, (char)';'), (MultivaluedMap<String, String>)params);
    }

    private static final class DummyPathSegment
    implements PathSegment {
        private final String path;
        private final MultivaluedMap<String, String> params;

        public DummyPathSegment(String path, MultivaluedMap<String, String> params) {
            this.path = path;
            this.params = params;
        }

        public String getPath() {
            return this.path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.params;
        }
    }
}

