/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import ru.ispras.texterra.api.Texterra;
import ru.ispras.texterra.core.rest.ekb.KBWalkerResource;
import ru.ispras.texterra.core.rest.ekb.RepresentationResource;
import ru.ispras.texterra.core.rest.ekb.SimilarityResource;
import ru.ispras.texterra.core.rest.nlp.NLPResource;
import ru.ispras.texterra.tools.nlp.representation.NLPPoweredRepresentation;

@Path(value="")
public class InterfaceSelector {
    private final Texterra texterra;

    public InterfaceSelector(Texterra texterra) {
        this.texterra = texterra;
    }

    @GET
    public String printUsage() {
        return "Texterra REST API InterfaceSelector is here";
    }

    @Path(value="nlp")
    public NLPResource selectPipeline() {
        return new NLPResource(this.texterra.getNLP());
    }

    @Path(value="walker")
    public KBWalkerResource selectKBWalker() {
        return new KBWalkerResource(this.texterra.getKBM().getKBWalker());
    }

    @Path(value="representation")
    public RepresentationResource selectRepresentation() {
        return new RepresentationResource(new NLPPoweredRepresentation(this.texterra.getKBM().getRepresentation(), this.texterra.getNLP()));
    }

    @Path(value="similarity")
    public SimilarityResource selectSimilarity() {
        return new SimilarityResource(this.texterra.getKBM().getSimilarityComputer());
    }
}

