/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.cli.nlp;

import ru.ispras.texterra.core.cli.nlp.FilteringOptions;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.factories.DefaultDocumentFactory;
import ru.ispras.texterra.core.nlp.utils.NLPDocumentFilteringUtils;
import ru.ispras.texterra.tools.nlp.ITexterraNLP;

public final class PipelineProcessor {
    private final ITexterraNLP.PipelineSpecification pipeline;
    private final FilteringOptions filteringOptions;
    private final ITexterraNLP nlp;

    public PipelineProcessor(ITexterraNLP.PipelineSpecification pipeline, FilteringOptions options, ITexterraNLP nlp) {
        this.pipeline = pipeline;
        this.filteringOptions = options;
        this.nlp = nlp;
    }

    public INLPDocument process(String text) {
        INLPDocument doc = this.nlp.traverse(new DefaultDocumentFactory().create(text), this.pipeline);
        return NLPDocumentFilteringUtils.filterAnnotations((INLPDocument)doc, (NLPDocumentFilteringUtils.FilteringOptions)this.filteringOptions.getFiltering(), this.filteringOptions.getClasses());
    }
}

