/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.cli.nlp;

import java.util.Optional;
import ru.ispras.texterra.cli.IDescribable;
import ru.ispras.texterra.core.common.concept.Domain;
import ru.ispras.texterra.core.nlp.datamodel.ConceptOccurrences;
import ru.ispras.texterra.core.nlp.datamodel.DisambiguatedPhrase;
import ru.ispras.texterra.core.nlp.datamodel.DomainAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.Emoticon;
import ru.ispras.texterra.core.nlp.datamodel.Frame;
import ru.ispras.texterra.core.nlp.datamodel.Hashtag;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.IsTweet;
import ru.ispras.texterra.core.nlp.datamodel.KeyconceptsSemanticContext;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.core.nlp.datamodel.Paragraph;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.SentimentPolarity;
import ru.ispras.texterra.core.nlp.datamodel.SentimentSubjectivity;
import ru.ispras.texterra.core.nlp.datamodel.URL;
import ru.ispras.texterra.core.nlp.datamodel.UserMention;
import ru.ispras.texterra.core.nlp.datamodel.anaphora.ICoreference;
import ru.ispras.texterra.core.nlp.datamodel.ne.NamedEntityToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.spelling.SpellingCorrectionToken;
import ru.ispras.texterra.core.nlp.datamodel.syntax.SyntaxRelation;
import ru.ispras.texterra.tools.nlp.ITexterraNLP;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;

public enum DefaultPipelineSpecification implements IDescribable
{
    PARAGRAPH("detect paragraphs", Paragraph.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{Paragraph.class});
        }
    }
    ,
    SENTENCE("detect sentences", Sentence.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{Sentence.class, Language.class});
        }
    }
    ,
    TOKEN("detect tokens", IToken.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    POS("detect part of speech tags", POSToken.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    LEMMA("compute words lemmas", Lemma.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{Lemma.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    SYNTAX("compute syntax relations", SyntaxRelation.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{SyntaxRelation.class, Lemma.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    TERM("detect terms", Frame.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{Frame.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    DISAMBIGUATION("disambiguate terms", DisambiguatedPhrase.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{DisambiguatedPhrase.class, Frame.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    KEYCONCEPTS("detect keyconcepts", KeyconceptsSemanticContext.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{KeyconceptsSemanticContext.class, ConceptOccurrences.class, DisambiguatedPhrase.class, Frame.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    SUBJECTIVITY("compute subjectivity", SentimentSubjectivity.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new NLPDocumentOptions().withOption(IsTweet.class, (Object)true), new Class[]{SentimentSubjectivity.class, URL.class, Lemma.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    POLARITY("compute polarity", SentimentPolarity.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new NLPDocumentOptions().withOption(IsTweet.class, (Object)true).withOption(DomainAnnotation.class, (Object)Domain.GENERAL), new Class[]{SentimentPolarity.class, SentimentSubjectivity.class, URL.class, Lemma.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    TWITTERDETECTION("detect twitter constructs", Hashtag.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new NLPDocumentOptions().withOption(IsTweet.class, (Object)true), new Class[]{Language.class, IToken.class, Emoticon.class, URL.class, UserMention.class, Hashtag.class, SpellingCorrectionToken.class});
        }
    }
    ,
    NAMEDENTITY("detect named entities", NamedEntityToken.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{NamedEntityToken.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    SPELLINGCORRECTION("correct spelling", SpellingCorrectionToken.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{SpellingCorrectionToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    LANGUAGE("detect language", Language.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{Language.class});
        }
    }
    ,
    DOMAIN("detect domain", DomainAnnotation.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{DomainAnnotation.class});
        }
    }
    ,
    DOMAINPOLARITY("compute polarity with respect to domain", SentimentPolarity.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return this.createPipelineSpec(new NLPDocumentOptions());
        }

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec(String param) {
            return this.createPipelineSpec(new NLPDocumentOptions().withOption(DomainAnnotation.class, (Object)new Domain(param)));
        }

        private ITexterraNLP.PipelineSpecification createPipelineSpec(NLPDocumentOptions options) {
            return DefaultPipelineSpecification.pipelineSpecFor(new NLPDocumentOptions().withOption(IsTweet.class, (Object)true).withOptions(options), new Class[]{SentimentPolarity.class, DomainAnnotation.class, SentimentSubjectivity.class, URL.class, Lemma.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    }
    ,
    COREFERENCE("resolves coreference relations", ICoreference.class){

        @Override
        protected ITexterraNLP.PipelineSpecification createPipelineSpec() {
            return DefaultPipelineSpecification.pipelineSpecFor(new Class[]{ICoreference.class, NamedEntityToken.class, SyntaxRelation.class, Lemma.class, POSToken.class, IToken.class, Sentence.class, Language.class});
        }
    };

    private final String description;
    private final Class<? extends IAnnotation> targetAnnotation;

    @SafeVarargs
    private static ITexterraNLP.PipelineSpecification pipelineSpecFor(Class<? extends IAnnotation> ... annotationTypes) {
        return DefaultPipelineSpecification.pipelineSpecFor(new NLPDocumentOptions(), annotationTypes);
    }

    @SafeVarargs
    private static ITexterraNLP.PipelineSpecification pipelineSpecFor(NLPDocumentOptions options, Class<? extends IAnnotation> ... annotationTypes) {
        return new ITexterraNLP.PipelineSpecification().withTargets((Class[])annotationTypes).withKnownOptions(options);
    }

    private DefaultPipelineSpecification(String description, Class<? extends IAnnotation> targetAnnotation) {
        this.description = description;
        this.targetAnnotation = targetAnnotation;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Class<? extends IAnnotation> getTargetAnnotation() {
        return this.targetAnnotation;
    }

    public ITexterraNLP.PipelineSpecification createPipelineSpec(Optional<String> param) {
        if (!param.isPresent()) {
            return this.createPipelineSpec();
        }
        return this.createPipelineSpec(param.get());
    }

    protected ITexterraNLP.PipelineSpecification createPipelineSpec(String param) {
        throw new UnsupportedOperationException();
    }

    protected abstract ITexterraNLP.PipelineSpecification createPipelineSpec();
}

