/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.cli.server.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.api.Texterra;
import ru.ispras.texterra.cli.server.IServer;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.rest.TexterraApplication;

public final class TexterraRESTServer
implements IServer {
    private static final Logger logger = Logger.getLogger(TexterraRESTServer.class);
    @ConfigurationProperty
    private static final String hostProperty = "host";
    @ConfigurationProperty
    private static final String portProperty = "port";
    @ConfigurationProperty
    private static final String pathProperty = "path";
    private final String scope;
    private final Function<String, Texterra> texterraFactory;
    private Texterra texterra;
    private HttpServer httpServer;

    public TexterraRESTServer(String scope, Function<String, Texterra> texterraFactory) {
        this.scope = scope;
        this.texterraFactory = texterraFactory;
    }

    @Override
    public synchronized void start() {
        if (this.texterra != null) {
            return;
        }
        this.texterra = this.texterraFactory.apply(this.scope);
        this.httpServer = new HttpServer();
        HttpHandler texterraHandler = (HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)new TexterraApplication(this.texterra), HttpHandler.class);
        texterraHandler.setAllowEncodedSlash(true);
        TexterraConfiguration configuration = TexterraConfigurationFactory.getConfiguration();
        int port = configuration.getIntProperty(this.getClass(), portProperty, this.scope);
        this.httpServer.addListener(new NetworkListener("texterra-listener", configuration.getStringProperty(this.getClass(), hostProperty, this.scope), port));
        this.httpServer.getServerConfiguration().addHttpHandler(texterraHandler, new String[]{"/" + configuration.getStringProperty(this.getClass(), pathProperty, this.scope) + "/*"});
        try {
            this.httpServer.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        logger.info((Object)String.format("Started Texterra REST server on port %d.", port));
    }

    @Override
    public synchronized void stop() {
        if (this.texterra == null) {
            return;
        }
        logger.info((Object)"Starting to stop Texterra REST server...");
        this.httpServer.stop();
        this.httpServer = null;
        this.texterra.close();
        this.texterra = null;
    }
}

