/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.cli;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;

public final class ConfigurationHelper {
    private static final Pattern propertyPattern = Pattern.compile("([^\\=]+)\\=(.+)");
    private static final String CONFIG_OPTION = "c";
    private static final String PROPERTY_OPTION = "S";
    private static final String SCOPE_OPTION = "s";

    public static void exposeOnCli(ArgumentParser parser) {
        parser.addArgument(new String[]{"-c"}).dest(CONFIG_OPTION).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).metavar(new String[]{"CONFIG.XML"}).help("configuration file");
        parser.addArgument(new String[]{"-S"}).dest(PROPERTY_OPTION).action((ArgumentAction)Arguments.append()).setDefault(new ArrayList()).metavar(new String[]{"PROPERTY=VALUE"}).help("configuration property");
        parser.addArgument(new String[]{"-s"}).dest(SCOPE_OPTION).setDefault((Object)TexterraConfiguration.NO_SCOPE).metavar(new String[]{"SCOPE"}).help("configuration scope");
    }

    public static void copyToSystemProperties(Namespace namespace) {
        System.getProperties().putAll(ConfigurationHelper.getProperties(namespace));
        String systemPropertyFiles = System.getProperty("texterra.properties.xml");
        List fromCmlFiles = namespace.getList(CONFIG_OPTION);
        if (systemPropertyFiles != null) {
            fromCmlFiles.add(0, systemPropertyFiles);
        }
        System.setProperty("texterra.properties.xml", StringUtils.join((Collection)fromCmlFiles, (String)File.pathSeparator));
    }

    private static Map<String, String> getProperties(Namespace namespace) {
        List propertiesValues = namespace.getList(PROPERTY_OPTION);
        return propertiesValues.stream().map(ConfigurationHelper::split).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map.Entry<String, String> split(String propertyValue) {
        Matcher m = propertyPattern.matcher(propertyValue);
        Validate.isTrue((boolean)m.matches(), (String)"%s is not correct property=value pair.", (Object[])new Object[0]);
        return new AbstractMap.SimpleEntry<String, String>(m.group(1), m.group(2));
    }

    public static String getScope(Namespace namespace) {
        return namespace.getString(SCOPE_OPTION);
    }
}

