/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.tools.nlp.syntax.pipelines.graph;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.maltparser.concurrent.ConcurrentMaltParserModel;
import org.maltparser.concurrent.ConcurrentMaltParserService;
import org.maltparser.core.exception.MaltChainedException;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.syntax.MaltParserSyntacticParser;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.syntax.SyntaxRelation;
import ru.ispras.texterra.tools.nlp.datamodel.NLPDocumentOptions;
import ru.ispras.texterra.tools.nlp.modelsio.AbstractOptionsBasedModelsIO;
import ru.ispras.texterra.tools.nlp.pipelines.graph.IPipelineNodeProvider;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNode;
import ru.ispras.texterra.tools.nlp.pipelines.graph.PipelineNodeDependencies;

public final class PersistentMaltParserSyntacticParserProvider
implements IPipelineNodeProvider<SyntaxRelation, MaltParserSyntacticParser>,
Serializable {
    private static final long serialVersionUID = -5123856197014761055L;
    @ConfigurationProperty
    private static final String modelNameProperty = "modelName";
    private static final String modelName = TexterraConfigurationFactory.getConfiguration().getStringProperty(PersistentMaltParserSyntacticParserProvider.class, "modelName");
    private final MaltParserModelsIO modelsIO = new MaltParserModelsIO(modelName);

    public PipelineNode<SyntaxRelation, MaltParserSyntacticParser> get(NLPDocumentOptions options) {
        return new PipelineNode(new PipelineNodeDependencies().withSoftImplicitDependencies(new Class[]{Sentence.class, IToken.class, POSToken.class, Lemma.class}), (IAnnotator)new MaltParserSyntacticParser(this.modelsIO.load(options)));
    }

    public Set<Class<? extends IValuedAnnotation<?>>> getRequiredOptions() {
        return Collections.singleton(Language.class);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj.getClass() == this.getClass();
    }

    private static final class MaltParserModelsIO
    extends AbstractOptionsBasedModelsIO<ConcurrentMaltParserModel>
    implements Serializable {
        private static final long serialVersionUID = -3958855278876401849L;
        private final String modelName;

        public MaltParserModelsIO(String modelName) {
            this.modelName = modelName;
        }

        public ConcurrentMaltParserModel load(NLPDocumentOptions options) {
            ConcurrentMaltParserModel concurrentMaltParserModel;
            String modelPath = this.getModelsPath(options);
            File modelFile = null;
            try {
                ConcurrentMaltParserModel model;
                modelFile = MaltParserModelsIO.makeFileFromResource((String)(modelPath + "/" + this.modelName));
                concurrentMaltParserModel = model = ConcurrentMaltParserService.initializeParserModel((File)modelFile);
            }
            catch (IOException | MaltChainedException e) {
                try {
                    throw new TexterraConfigException(e);
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(modelFile);
                    throw throwable;
                }
            }
            FileUtils.deleteQuietly((File)modelFile);
            return concurrentMaltParserModel;
        }

        public void save(NLPDocumentOptions options, ConcurrentMaltParserModel model) {
            throw new UnsupportedOperationException();
        }
    }
}

