/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.syntax.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXDocument;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXSentence;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXToken;
import ru.ispras.texterra.core.nlp.datamodel.FastInRelationNLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.Lemma;
import ru.ispras.texterra.core.nlp.datamodel.Sentence;
import ru.ispras.texterra.core.nlp.datamodel.pos.POSToken;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.IMorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;
import ru.ispras.texterra.core.nlp.datamodel.relations.CoinsidesAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.CoinsidesAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainsAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainsAnnotationRelationCacheBuilder;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;

public class NLPDocument2ConllXTransformer {
    private static final IAnnotationRelation coinsides = new CoinsidesAnnotationRelation();
    private static final IAnnotationRelationCacheBuilder coinsidesCacheBuilder = new CoinsidesAnnotationRelationCacheBuilder();
    private static final IAnnotationRelation contains = new ContainsAnnotationRelation();
    private static final IAnnotationRelationCacheBuilder containsCacheBuilder = new ContainsAnnotationRelationCacheBuilder();

    public ConllXDocument transform(INLPDocument nlpDoc) {
        FastInRelationNLPDocument fastNLPDoc = new FastInRelationNLPDocument(nlpDoc, Sentence.class, IToken.class, containsCacheBuilder);
        fastNLPDoc = new FastInRelationNLPDocument((INLPDocument)fastNLPDoc, IToken.class, POSToken.class, coinsidesCacheBuilder);
        fastNLPDoc = new FastInRelationNLPDocument((INLPDocument)fastNLPDoc, IToken.class, Lemma.class, coinsidesCacheBuilder);
        List origSentences = nlpDoc.getAnnotations(Sentence.class);
        ArrayList<ConllXSentence> conllSentences = new ArrayList<ConllXSentence>(origSentences.size());
        for (Sentence sentence : origSentences) {
            conllSentences.add(this.transformSentence((INLPDocument)fastNLPDoc, sentence));
        }
        return new ConllXDocument(nlpDoc, conllSentences);
    }

    private ConllXSentence transformSentence(INLPDocument nlpDoc, Sentence sentence) {
        List tokens = nlpDoc.getInRelationAnnotations((IAnnotation)sentence, contains, IToken.class);
        ArrayList<ConllXToken> result = new ArrayList<ConllXToken>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            result.add(this.transformToken(nlpDoc, i > 0 ? (IToken)tokens.get(i - 1) : null, (IToken)tokens.get(i), i < tokens.size() - 1 ? (IToken)tokens.get(i + 1) : null, i + 1));
        }
        return new ConllXSentence(sentence, result);
    }

    private ConllXToken transformToken(INLPDocument nlpDoc, IToken prevToken, IToken token, IToken nextToken, int id) {
        String form = (String)token.getValue();
        String lemma = ((String)((Lemma)nlpDoc.getInRelationAnnotations((IAnnotation)token, coinsides, Lemma.class).get(0)).getValue()).toUpperCase();
        POSToken posToken = (POSToken)nlpDoc.getInRelationAnnotations((IAnnotation)token, coinsides, POSToken.class).get(0);
        IMorphProperties posTag = (IMorphProperties)posToken.getValue();
        HashSet<String> feats = new HashSet<String>();
        if (posTag.isPunctuation()) {
            feats.add(this.getPunctuationMorphProperties(prevToken, token, nextToken));
        }
        String posTagValue = posTag.getPOSTag().getTag();
        feats.addAll(this.generateFeats(posTag));
        return new ConllXToken(token, id, form, posTagValue, posTagValue, lemma, feats);
    }

    private String getPunctuationMorphProperties(IToken prev, IToken punct, IToken next) {
        boolean rightSpace;
        boolean leftSpace = prev != null && prev.getEnd() < punct.getStart();
        boolean bl = rightSpace = next != null && punct.getEnd() < next.getStart();
        if (leftSpace) {
            return rightSpace ? "n" : "r";
        }
        return rightSpace ? "l" : "b";
    }

    private Collection<String> generateFeats(IMorphProperties morphProperties) {
        Collection morphCharacters = morphProperties.getMorphCharacters();
        if (morphCharacters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(morphCharacters.size());
        for (IMorphCharacter mc : morphCharacters) {
            result.add(mc.getValue());
        }
        return result;
    }
}

