/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.syntax;

import java.util.ArrayList;
import java.util.Collection;
import org.maltparser.concurrent.ConcurrentMaltParserModel;
import org.maltparser.concurrent.graph.ConcurrentDependencyGraph;
import org.maltparser.concurrent.graph.ConcurrentDependencyNode;
import org.maltparser.core.exception.MaltChainedException;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllX2NLPDocumentTransformer;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXDocument;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXSentence;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.ConllXToken;
import ru.ispras.texterra.core.nlp.annotators.syntax.transform.NLPDocument2ConllXTransformer;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.syntax.SyntaxRelation;

public class MaltParserSyntacticParser
implements IAnnotator<SyntaxRelation> {
    private final ConcurrentMaltParserModel model;
    private final NLPDocument2ConllXTransformer nlpDocTransformer;
    private final ConllX2NLPDocumentTransformer conllXTransformer;

    public MaltParserSyntacticParser(ConcurrentMaltParserModel model) {
        this.model = model;
        this.nlpDocTransformer = new NLPDocument2ConllXTransformer();
        this.conllXTransformer = new ConllX2NLPDocumentTransformer();
    }

    public Collection<SyntaxRelation> annotate(INLPDocument doc) {
        ConllXDocument conllDoc = this.nlpDocTransformer.transform(doc);
        try {
            ConllXDocument parsedDoc = this.parse(conllDoc);
            return this.conllXTransformer.transform(parsedDoc);
        }
        catch (MaltChainedException e) {
            throw new TexterraSystemException((Throwable)e);
        }
    }

    private ConllXDocument parse(ConllXDocument doc) throws MaltChainedException {
        ArrayList<ConllXSentence> parsedSentences = new ArrayList<ConllXSentence>();
        for (ConllXSentence sentence : doc) {
            parsedSentences.add(this.parse(sentence));
        }
        return new ConllXDocument(doc.getOriginal(), parsedSentences);
    }

    private ConllXSentence parse(ConllXSentence sentence) throws MaltChainedException {
        String[] tokens = sentence.getStringTokens().toArray(new String[0]);
        ConcurrentDependencyGraph syntaxStructure = this.model.parse(tokens);
        ArrayList<ConllXToken> parsedTokens = new ArrayList<ConllXToken>(tokens.length);
        int index = 1;
        for (ConllXToken token : sentence) {
            assert (token.getId() == index);
            ConcurrentDependencyNode node = syntaxStructure.getDependencyNode(index++);
            parsedTokens.add(new ConllXToken(token, node.getHeadIndex(), node.getLabel("DEPREL")));
        }
        return new ConllXSentence(sentence.getOriginal(), parsedTokens);
    }
}

