/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import ru.ispras.texterra.core.common.concept.AttributedConcept;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarityComputer;
import ru.ispras.texterra.core.ekb.similarity.FullSimilarityGraph;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.serializers.ISerializer;
import ru.ispras.texterra.core.nlp.serializers.simple.SimpleSerializerFactory;
import ru.ispras.texterra.core.rest.ekb.ConceptResource;
import ru.ispras.texterra.core.rest.ekb.ConceptsSimilarityResource;

@Produces(value={"application/xml"})
public class XmlMessageBodyWriter
implements MessageBodyWriter<Object> {
    private static final Set<Class<?>> classes = new HashSet();
    private final ISerializer serializer = new SimpleSerializerFactory().create();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type)) {
            Type collectionParameterType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            return this.supports(collectionParameterType);
        }
        if (Map.class.isAssignableFrom(type)) {
            Type[] parameterTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            Type keyParameterType = parameterTypes[0];
            Type valueParameterType = parameterTypes[1];
            return this.supports(keyParameterType) && this.supports(valueParameterType);
        }
        return this.supports(type);
    }

    private boolean supports(Type type) {
        return type instanceof Class && this.supports((Class)type);
    }

    private boolean supports(Class<?> type) {
        for (Class<?> c : classes) {
            if (!c.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (Collection.class.isAssignableFrom(type)) {
            this.serializer.write(new Elements(new ArrayList((Collection)t)), entityStream);
        } else if (Map.class.isAssignableFrom(type)) {
            this.serializer.write((Object)new Entries((Map)t), entityStream);
        } else {
            this.serializer.write(t, entityStream);
        }
    }

    static {
        classes.add(INLPDocument.class);
        classes.add(IAnnotation.class);
        classes.add(AttributedConcept.class);
        classes.add(Concept.class);
        classes.add(IAttribute.class);
        classes.add(String.class);
        classes.add(Number.class);
        classes.add(FullSimilarityGraph.class);
        classes.add(ISimilarityComputer.ConceptWithSimilarity.class);
        classes.add(ConceptResource.Size.class);
        classes.add(ConceptsSimilarityResource.RelatednessToContext.class);
        classes.add(ConceptsSimilarityResource.VirtualArticlesSimilarity.class);
        classes.add(ConceptsSimilarityResource.AllPairsSimilarity.class);
    }

    @Root
    public static class Entries {
        @ElementMap(inline=true)
        public Map<?, ?> map;

        public Entries(@ElementMap(inline=true) Map<?, ?> map) {
            this.map = map;
        }
    }

    @Root
    public static class Elements<T> {
        @ElementList(inline=true)
        private final List<T> elements;

        public Elements(@ElementList(inline=true) List<T> elements) {
            this.elements = elements;
        }

        public List<T> getElements() {
            return this.elements;
        }
    }
}

