/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.extractors;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.ParamConverter;
import ru.ispras.texterra.core.common.concept.TypeAttribute;
import ru.ispras.texterra.core.rest.converters.EnumLowerCaseConverter;
import ru.ispras.texterra.utils.datamodel.Link;

public class ConceptNeighboursMatrixParamExtractor {
    private static final ParamConverter<Link.Type> LINK_TYPE_CONVERTER = new EnumLowerCaseConverter().getConverter(Link.Type.class, (Type)((Object)Link.Type.class), Link.Type.class.getAnnotations());
    private static final ParamConverter<TypeAttribute.NodeType> NODE_TYPE_CONVERTER = new EnumLowerCaseConverter().getConverter(TypeAttribute.NodeType.class, (Type)((Object)TypeAttribute.NodeType.class), TypeAttribute.NodeType.class.getAnnotations());
    private final Set<Link.Type> linkTypes;
    private final Set<TypeAttribute.NodeType> nodeTypes;
    private final int minDepth;
    private final int maxDepth;

    public ConceptNeighboursMatrixParamExtractor(PathSegment pathSegment) {
        this.linkTypes = this.getLinkTypes(pathSegment);
        this.nodeTypes = this.getNodeTypes(pathSegment);
        this.minDepth = this.parseInteger(pathSegment, "minDepth");
        this.maxDepth = this.parseInteger(pathSegment, "maxDepth");
    }

    private Set<Link.Type> getLinkTypes(PathSegment pathSegment) {
        HashSet<Link.Type> linkTypes = new HashSet<Link.Type>();
        List<String> linkTypesParams = this.getMatrixParameters(pathSegment, "linkType");
        for (String linkTypeParam : linkTypesParams) {
            linkTypes.add((Link.Type)LINK_TYPE_CONVERTER.fromString(linkTypeParam));
        }
        return linkTypes;
    }

    private Set<TypeAttribute.NodeType> getNodeTypes(PathSegment pathSegment) {
        HashSet<TypeAttribute.NodeType> nodeTypes = new HashSet<TypeAttribute.NodeType>();
        List<String> nodeTypesParams = this.getMatrixParameters(pathSegment, "nodeType");
        for (String nodeTypeParam : nodeTypesParams) {
            nodeTypes.add((TypeAttribute.NodeType)NODE_TYPE_CONVERTER.fromString(nodeTypeParam));
        }
        return nodeTypes;
    }

    private List<String> getMatrixParameters(PathSegment pathSegment, String parameter) {
        List values = (List)pathSegment.getMatrixParameters().get((Object)parameter);
        return values == null ? Collections.emptyList() : values;
    }

    private int parseInteger(PathSegment pathSegment, String parameter) {
        List<String> values = this.getMatrixParameters(pathSegment, parameter);
        return values.isEmpty() ? -1 : Integer.parseInt(values.get(0));
    }

    public Set<Link.Type> getLinkTypes() {
        return this.linkTypes;
    }

    public Set<TypeAttribute.NodeType> getNodeTypes() {
        return this.nodeTypes;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }
}

