/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.ekb;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.ekb.interfaces.ILinkWeightComputer;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarCandidatesFilter;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarityComputer;

@Path(value="")
public class SimilarResource {
    private ISimilarityComputer similarityComputer;
    private List<Concept> concepts;
    private ILinkWeightComputer linkWeightComputer;
    private int offset;
    private int limit;

    public SimilarResource(ISimilarityComputer similarityComputer, List<Concept> concepts, ILinkWeightComputer linkWeightComputer, int offset, int limit) {
        this.similarityComputer = similarityComputer;
        this.concepts = concepts;
        this.linkWeightComputer = linkWeightComputer;
        this.offset = offset;
        this.limit = limit;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="neighbours")
    public List<ISimilarityComputer.ConceptWithSimilarity> getSimilar() {
        return this.extractPartAtOffset(this.similarityComputer.getSimilar(this.concepts, this.linkWeightComputer, this.offset + this.limit), this.offset, this.limit);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="all")
    public List<ISimilarityComputer.ConceptWithSimilarity> getSimilar(@QueryParam(value="among") ISimilarCandidatesFilter candidatesFilter) {
        if (candidatesFilter != null) {
            return this.extractPartAtOffset(this.similarityComputer.getSimilar(this.concepts, this.linkWeightComputer, candidatesFilter, this.offset + this.limit), this.offset, this.limit);
        }
        if (this.concepts.size() == 1) {
            return this.extractPartAtOffset(this.similarityComputer.getSimilarAmongAll(this.concepts.get(0), this.linkWeightComputer, this.offset + this.limit), this.offset, this.limit);
        }
        throw new IllegalArgumentException("Among ALL is only supported for single concept!");
    }

    private <T> List<T> extractPartAtOffset(List<T> list, int offset, int limit) {
        int left = Math.min(offset, list.size());
        int right = Math.min(offset + limit, list.size());
        return new ArrayList<T>(list.subList(left, right));
    }
}

