/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.ekb;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.tools.nlp.representation.NLPPoweredRepresentation;

@Path(value="")
public class RepresentationResource {
    private final NLPPoweredRepresentation representation;

    public RepresentationResource(NLPPoweredRepresentation representation) {
        this.representation = representation;
    }

    @GET
    public String printUsage() {
        return "Please choose representation method.";
    }

    @POST
    @Path(value="terms")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public INLPDocument selectTerms(INLPDocument doc, @QueryParam(value="featureType") List<Class<? extends IAnnotation>> featuresTypes) {
        return this.representation.getTerms(doc, featuresTypes);
    }

    @POST
    @Path(value="allTerms")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public INLPDocument selectAllTerms(String text, @QueryParam(value="featureType") List<Class<? extends IAnnotation>> featuresTypes) {
        return this.representation.getAllTerms(text, featuresTypes);
    }
}

