/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.ekb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.PathSegment;
import org.apache.commons.lang.ArrayUtils;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Text;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.ekb.interfaces.ILinkWeightComputer;
import ru.ispras.texterra.core.ekb.interfaces.ISimilarityComputer;
import ru.ispras.texterra.core.ekb.similarity.FullSimilarityGraph;
import ru.ispras.texterra.core.rest.WeightedConcept;
import ru.ispras.texterra.core.rest.ekb.SimilarResource;
import ru.ispras.texterra.core.rest.extractors.ConceptPathMatrixParamExtractor;
import ru.ispras.texterra.core.rest.extractors.WeightedConceptPathMatrixParamExtractor;

@Path(value="")
public class ConceptsSimilarityResource {
    private final ISimilarityComputer similarityComputer;
    private final List<Concept> concepts;
    private final ILinkWeightComputer linkWeightComputer;

    public ConceptsSimilarityResource(ISimilarityComputer similarityComputer, List<Concept> concepts, ILinkWeightComputer linkWeightComputer) {
        this.similarityComputer = similarityComputer;
        this.concepts = concepts;
        this.linkWeightComputer = linkWeightComputer;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="graph")
    public FullSimilarityGraph computeFullSimilarityGraph() {
        return this.similarityComputer.computeFullSimilarityGraph(this.concepts, this.linkWeightComputer);
    }

    @Produces(value={"application/xml"})
    @Path(value="similar")
    public SimilarResource getSimilar(@QueryParam(value="offset") int offset, @QueryParam(value="limit") @DefaultValue(value="50") int limit) {
        return new SimilarResource(this.similarityComputer, this.concepts, this.linkWeightComputer, offset, limit);
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/summed/{concepts}")
    public AllPairsSimilarity computeAllPairsSimilarity(@PathParam(value="concepts") PathSegment conceptsParam) {
        List<Concept> unweightedPart = new ConceptPathMatrixParamExtractor().getConcepts(conceptsParam);
        List<WeightedConcept> weightedPart = new WeightedConceptPathMatrixParamExtractor().getConcepts(conceptsParam);
        Map<Concept, Double> weightedContext = this.mergeWeights(unweightedPart, weightedPart);
        return new AllPairsSimilarity(this.similarityComputer.allPairsSimilarity(this.concepts, weightedContext, this.linkWeightComputer));
    }

    private Map<Concept, Double> mergeWeights(List<Concept> unweighted, List<WeightedConcept> weighted) {
        Double value;
        HashMap<Concept, Double> result = new HashMap<Concept, Double>();
        for (Concept concept : unweighted) {
            value = (Double)result.get(concept);
            if (value == null) {
                value = 0.0;
            }
            result.put(concept, value + 1.0);
        }
        for (WeightedConcept wc : weighted) {
            value = (Double)result.get(wc.getConcept());
            if (value == null) {
                value = 0.0;
            }
            result.put(wc.getConcept(), value + wc.getWeight());
        }
        return result;
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/toVirtualArticle/{concepts}")
    public RelatednessToContext computeRelatednessToContext(@PathParam(value="concepts") PathSegment conceptsParam) {
        List<Concept> context = new ConceptPathMatrixParamExtractor().getConcepts(conceptsParam);
        return new RelatednessToContext(this.similarityComputer.relatednessToContext(this.concepts, context, this.linkWeightComputer));
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/betweenVirtualArticles/{concepts}")
    public VirtualArticlesSimilarity computeSimilarity(@PathParam(value="concepts") PathSegment conceptsParam) {
        List<Concept> context = new ConceptPathMatrixParamExtractor().getConcepts(conceptsParam);
        return new VirtualArticlesSimilarity(this.similarityComputer.relatednessBetweenGroups(this.concepts, context, this.linkWeightComputer));
    }

    public static class VirtualArticlesSimilarity {
        @Text
        private final double virtualArticlesSimilarity;

        public VirtualArticlesSimilarity(@Text double virtualArticlesSimilarity) {
            this.virtualArticlesSimilarity = virtualArticlesSimilarity;
        }

        public double getVirtualArticlesSimilarity() {
            return this.virtualArticlesSimilarity;
        }
    }

    public static class RelatednessToContext {
        @ElementList(name="relatedness", inline=true, entry="rel")
        private List<Double> relatedness;

        public RelatednessToContext(double[] relatedness) {
            this.relatedness = Arrays.asList(ArrayUtils.toObject((double[])relatedness));
        }

        public RelatednessToContext(@ElementList(name="relatedness", inline=true, entry="rel") List<Double> relatedness) {
            this.relatedness = relatedness;
        }

        public double[] getRelatedness() {
            return ArrayUtils.toPrimitive((Double[])this.relatedness.toArray(new Double[0]));
        }
    }

    public static class AllPairsSimilarity {
        @ElementList(name="all-pairs-similarity", inline=true, entry="sim")
        private List<Double> similarities;

        public AllPairsSimilarity(double[] similarities) {
            this.similarities = Arrays.asList(ArrayUtils.toObject((double[])similarities));
        }

        public AllPairsSimilarity(@ElementList(name="all-pairs-similarity", inline=true, entry="sim") List<Double> similarities) {
            this.similarities = similarities;
        }

        public double[] getSimilarity() {
            return ArrayUtils.toPrimitive((Double[])this.similarities.toArray(new Double[0]));
        }
    }
}

