/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.ekb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.PathSegment;
import org.simpleframework.xml.Text;
import ru.ispras.texterra.core.common.concept.AttributedConcept;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.common.concept.IAttribute;
import ru.ispras.texterra.core.common.concept.TypeAttribute;
import ru.ispras.texterra.core.ekb.interfaces.IKBWalker;
import ru.ispras.texterra.core.rest.extractors.ConceptNeighboursMatrixParamExtractor;
import ru.ispras.texterra.serializers.json.datamodel.AttributedConceptSet;
import ru.ispras.texterra.utils.datamodel.Link;

@Path(value="")
public class ConceptResource {
    private final IKBWalker kbWalker;
    private final List<Concept> concepts;

    public ConceptResource(IKBWalker kbWalker, Concept concept) {
        this(kbWalker, Arrays.asList(concept));
    }

    public ConceptResource(IKBWalker kbWalker, List<Concept> concepts) {
        this.kbWalker = kbWalker;
        this.concepts = concepts;
    }

    @GET
    @Produces(value={"application/xml"})
    public List<AttributedConcept> get(@QueryParam(value="attribute") List<IAttribute> attributes) {
        return this.kbWalker.getAttributedConcept(this.concepts, attributes);
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public AttributedConceptSet getJSON(@QueryParam(value="attribute") List<IAttribute> attributes) {
        return AttributedConceptSet.of((Iterable)this.kbWalker.getAttributedConcept(this.concepts, attributes));
    }

    @GET
    @Path(value="size")
    public Size getSize() {
        return new Size(this.concepts.size());
    }

    @Path(value="{neighbours:neighbours}")
    public ConceptResource getNeighbours(@PathParam(value="neighbours") PathSegment neighboursSegment) {
        ConceptNeighboursMatrixParamExtractor extractor = new ConceptNeighboursMatrixParamExtractor(neighboursSegment);
        return new ConceptResource(this.kbWalker, this.getConceptNeighbours(extractor.getLinkTypes(), extractor.getNodeTypes(), extractor.getMinDepth(), extractor.getMaxDepth()));
    }

    private List<Concept> getConceptNeighbours(Set<Link.Type> linkTypes, Set<TypeAttribute.NodeType> nodeTypes, int minDepth, int maxDepth) {
        HashSet<Concept> result = new HashSet<Concept>();
        for (Concept concept : this.concepts) {
            this.addConceptNeighbours(result, concept, linkTypes, nodeTypes, minDepth, maxDepth);
        }
        return new ArrayList<Concept>(result);
    }

    private void addConceptNeighbours(Set<Concept> result, Concept concept, Set<Link.Type> linkTypes, Set<TypeAttribute.NodeType> nodeTypes, int minDepth, int maxDepth) {
        if (linkTypes.isEmpty() && nodeTypes.isEmpty() && minDepth < 0 && maxDepth < 0) {
            result.addAll(this.kbWalker.getNeighbours(concept));
        } else if (!linkTypes.isEmpty() && !nodeTypes.isEmpty() && minDepth >= 0 && maxDepth >= 0) {
            result.addAll(this.kbWalker.getNeighbours(concept, linkTypes, nodeTypes, minDepth, maxDepth));
        } else {
            throw new IllegalArgumentException("linkType, nodeType, minDepth, maxDepth parameters should be all specified or omitted.");
        }
    }

    public static class Size {
        @Text
        private final int size;

        public Size(@Text int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

