/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.rest.WeightedConcept;
import ru.ispras.texterra.core.rest.converters.ConceptConverter;

public class WeightedConceptConverter
implements ParamConverterProvider {
    private final ParamConverter<Concept> CONVERTER = new ConceptConverter().getConverter(Concept.class, (Type)((Object)Concept.class), Concept.class.getAnnotations());

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (WeightedConcept.class.isAssignableFrom(rawType)) {
            return new ParamConverter<T>(){
                private static final String DELIMITER = ":";

                public T fromString(String weightedConcept) {
                    int weightStart = weightedConcept.lastIndexOf(DELIMITER);
                    if (weightStart < 0) {
                        throw new IllegalArgumentException("Weighted concept should contain weight after delimiter ':'");
                    }
                    double weight = Double.parseDouble(weightedConcept.substring(weightStart + 1));
                    Concept concept = (Concept)WeightedConceptConverter.this.CONVERTER.fromString(weightedConcept.substring(0, weightStart));
                    WeightedConcept result = new WeightedConcept(concept, weight);
                    return rawType.cast(result);
                }

                public String toString(T value) {
                    WeightedConcept weightedConcept = (WeightedConcept)value;
                    return WeightedConceptConverter.this.CONVERTER.toString((Object)weightedConcept.getConcept()) + DELIMITER + weightedConcept.getWeight();
                }
            };
        }
        return null;
    }
}

