/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public abstract class InstanceConverter<T>
implements ParamConverterProvider {
    private final Class<T> superClass;
    private final Map<String, Class<? extends T>> shortcuts;
    private static final Pattern PATTERN = Pattern.compile("([a-zA-Z0-9._]+)(\\((.+)\\))?");

    public InstanceConverter(Class<T> superClass, Map<String, Class<? extends T>> shortcuts) {
        this.superClass = superClass;
        this.shortcuts = shortcuts;
    }

    public InstanceConverter(Class<T> superClass) {
        this(superClass, Collections.emptyMap());
    }

    public <P> ParamConverter<P> getConverter(final Class<P> rawType, Type genericType, Annotation[] annotations) {
        return this.superClass.isAssignableFrom(rawType) ? new ParamConverter<P>(){

            public P fromString(String value) {
                return rawType.cast(InstanceConverter.this.instantiate(value));
            }

            public String toString(P value) {
                return value.getClass().getName();
            }
        } : null;
    }

    private T instantiate(String value) {
        Matcher matcher = PATTERN.matcher(value);
        if (matcher.matches()) {
            Class<T> desiredClass = this.makeClass(matcher.group(1));
            String param = matcher.group(3);
            if (param != null) {
                return this.instantiateWithParam(desiredClass, param);
            }
            try {
                return desiredClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(String.format("%s should have default constructor.", desiredClass.getName()));
            }
        }
        throw new IllegalArgumentException(String.format("%s should be FQN of %s subclass or its shortcut optionally followed by parameter value in parentheses", value, this.superClass));
    }

    private T instantiateWithParam(Class<? extends T> desiredClass, String param) {
        try {
            int intParam = Integer.parseInt(param);
            Constructor<T> constructor = desiredClass.getConstructor(Integer.TYPE);
            return constructor.newInstance(intParam);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException parseInt) {
            try {
                double doubleParam = Double.parseDouble(param);
                Constructor<T> constructor = desiredClass.getConstructor(Double.TYPE);
                return constructor.newInstance(doubleParam);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException parseDouble) {
                try {
                    Constructor<T> constructor = desiredClass.getConstructor(String.class);
                    return constructor.newInstance(param);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalArgumentException(String.format("Cannot use constructor from String in class %s.", desiredClass.getName()));
                }
            }
        }
    }

    private Class<? extends T> makeClass(String className) {
        if (this.shortcuts.containsKey(className)) {
            return this.shortcuts.get(className);
        }
        try {
            Class<?> forName = Class.forName(className);
            Class<T> asSubclass = forName.asSubclass(this.superClass);
            return asSubclass;
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("%s should be either valid shortcut value or FQN of %s subclass.", className, this.superClass));
        }
    }
}

