/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class EnumLowerCaseConverter
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        return Enum.class.isAssignableFrom(rawType) ? new ParamConverter<T>(){

            public T fromString(String value) {
                try {
                    Method declaredMethod = rawType.getDeclaredMethod("valueOf", String.class);
                    Object invoke = declaredMethod.invoke((Object)rawType, value.toUpperCase());
                    return rawType.cast(invoke);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public String toString(T value) {
                return value.toString();
            }
        } : null;
    }
}

