/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import ru.ispras.texterra.core.rest.ErrorInfo;

public class ClassConverter
implements ParamConverterProvider {
    private final String description;
    private final Map<String, Class<?>> shortcuts;

    public ClassConverter(String description, Map<String, Class<?>> shortcuts) {
        this.description = description;
        this.shortcuts = shortcuts;
    }

    public ClassConverter(String description) {
        this(description, Collections.emptyMap());
    }

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        return rawType.isAssignableFrom(Class.class) && this.supported(genericType) ? new ParamConverter<T>(){

            public T fromString(String value) {
                if (ClassConverter.this.shortcuts.containsKey(value)) {
                    return rawType.cast(ClassConverter.this.shortcuts.get(value));
                }
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorInfo(String.format("'%s' is not a valid %s.", value, ClassConverter.this.description))).build());
            }

            public String toString(T value) {
                if (value instanceof Class) {
                    Class classValue = (Class)value;
                    return classValue.getName();
                }
                throw new IllegalArgumentException(String.format("%s should be Class<?> instance", value));
            }
        } : null;
    }

    protected boolean supported(Type genericType) {
        return true;
    }
}

