/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.rest;

import java.util.List;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import ru.ispras.texterra.core.rest.MatrixParamExtractor;

public class PathMatrixParamExtractor<T> {
    private final ParamConverter<T> converter;
    private final String prefix;
    private final MatrixParamExtractor<T> matrixParamExtractor;

    public PathMatrixParamExtractor(String paramName, ParamConverterProvider provider, Class<T> extractedClass) {
        this.converter = provider.getConverter(extractedClass, extractedClass, extractedClass.getAnnotations());
        this.prefix = paramName + "=";
        this.matrixParamExtractor = new MatrixParamExtractor<T>(paramName, this.converter);
    }

    public List<T> extract(PathSegment pathSegment) {
        List<T> result = this.matrixParamExtractor.extract(pathSegment);
        if (pathSegment.getPath().startsWith(this.prefix)) {
            result.add(this.converter.fromString(pathSegment.getPath().substring(this.prefix.length())));
        }
        return result;
    }

    public PathSegment construct(List<T> elements) {
        return this.matrixParamExtractor.construct(elements);
    }
}

