/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.cli.server.admin;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.cli.IDescribable;
import ru.ispras.texterra.cli.server.IServer;
import ru.ispras.texterra.cli.server.admin.SocketUtil;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;

public final class TexterraAdminServer
implements IServer {
    @ConfigurationProperty
    private static final String PORT = "port";
    protected static final String SHUTDOWN_COMMAND = "SHUTDOWN";
    protected static final String STATUS = "STATUS";
    private final String scope;
    private Thread worker;
    private volatile boolean shouldContinue = true;
    private volatile Status status = Status.Loading;

    public TexterraAdminServer(String scope) {
        this.scope = scope;
    }

    @Override
    public synchronized void start() {
        if (this.worker != null) {
            return;
        }
        this.worker = new Thread(){
            private final ServerSocket serverSocket = this.createServerSocket();

            @Override
            public void run() {
                while (TexterraAdminServer.this.shouldContinue) {
                    this.waitForCommand(this.serverSocket);
                }
            }

            private ServerSocket createServerSocket() {
                try {
                    return new ServerSocket(TexterraAdminServer.getPort(TexterraAdminServer.this.scope));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private void waitForCommand(ServerSocket serverSocket) {
                try (Socket socket = serverSocket.accept();){
                    socket.setSoTimeout(10000);
                    int commandSize = Math.max(TexterraAdminServer.SHUTDOWN_COMMAND.length(), TexterraAdminServer.STATUS.length());
                    String command = SocketUtil.read(socket, commandSize);
                    if (command.equals(TexterraAdminServer.SHUTDOWN_COMMAND)) {
                        System.exit(0);
                    }
                    if (command.equals(TexterraAdminServer.STATUS)) {
                        SocketUtil.write(TexterraAdminServer.this.status.name(), socket);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.worker.setDaemon(true);
        this.worker.start();
    }

    @Override
    public synchronized void stop() {
        this.shouldContinue = false;
        this.worker = null;
    }

    public void setStarted() {
        this.status = Status.Started;
    }

    protected static int getPort(String scope) {
        return TexterraConfigurationFactory.getConfiguration().getIntProperty(TexterraAdminServer.class, PORT, scope);
    }

    public static enum Status implements IDescribable
    {
        Loading("Server is loading"),
        Started("Server has started"),
        Stopped("Server is stopped");

        private final String description;

        private Status(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

