/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.cli.server.admin;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import ru.ispras.texterra.cli.server.admin.SocketUtil;
import ru.ispras.texterra.cli.server.admin.TexterraAdminServer;

public final class ServerManager {
    public static void stop(String scope) {
        try (Socket socket = new Socket("localhost", TexterraAdminServer.getPort(scope));){
            SocketUtil.write("SHUTDOWN", socket);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TexterraAdminServer.Status getStatus(String scope) {
        try (Socket socket = new Socket("localhost", TexterraAdminServer.getPort(scope));){
            SocketUtil.write("STATUS", socket);
            TexterraAdminServer.Status status = TexterraAdminServer.Status.valueOf(SocketUtil.read(socket, ServerManager.computeMaxMessageLength()));
            return status;
        }
        catch (IOException | RuntimeException e) {
            return TexterraAdminServer.Status.Stopped;
        }
    }

    private static int computeMaxMessageLength() {
        int length = 0;
        for (TexterraAdminServer.Status status : TexterraAdminServer.Status.values()) {
            length = Math.max(length, status.name().length());
        }
        return length;
    }
}

