/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.cli.server;

import java.io.Serializable;
import java.util.function.Function;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;
import ru.ispras.texterra.api.Texterra;
import ru.ispras.texterra.cli.ConfigurationHelper;
import ru.ispras.texterra.cli.SubcommandHelper;
import ru.ispras.texterra.cli.server.IServer;
import ru.ispras.texterra.cli.server.ServerCommand;
import ru.ispras.texterra.cli.server.TexterraHolder;
import ru.ispras.texterra.cli.server.admin.ServerManager;
import ru.ispras.texterra.cli.server.admin.TexterraAdminServer;
import ru.ispras.texterra.cli.server.rest.TexterraRESTServer;

public final class ServerCLI {
    private static final String SERVER_COMMAND = "SERVER_COMMAND";

    public static void exposeOnCli(ArgumentParser parser) {
        Subparsers subparsers = parser.addSubparsers().dest(SERVER_COMMAND).metavar(SERVER_COMMAND).title("available commands");
        SubcommandHelper.add(subparsers, ServerCommand.start);
        SubcommandHelper.add(subparsers, ServerCommand.stop);
        SubcommandHelper.add(subparsers, ServerCommand.status);
    }

    public static void execute(Namespace namespace) {
        ServerCommand command = ServerCommand.valueOf(namespace.getString(SERVER_COMMAND));
        switch (command) {
            case start: {
                ServerCLI.executeStart(namespace);
                return;
            }
            case stop: {
                ServerCLI.executeStop(namespace);
                return;
            }
            case status: {
                ServerCLI.executeStatus(namespace);
                return;
            }
        }
        throw new IllegalStateException();
    }

    private static void executeStart(Namespace namespace) {
        TexterraAdminServer.Status status = ServerCLI.getStatus(namespace);
        if (status != TexterraAdminServer.Status.Stopped) {
            System.err.println("Server is currently running. Please stop it before starting.");
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(TexterraHolder::close));
        String scope = ConfigurationHelper.getScope(namespace);
        TexterraAdminServer adminServer = new TexterraAdminServer(scope);
        ServerCLI.start(adminServer);
        IServer server = ServerCLI.getServer(scope);
        ServerCLI.start(server);
        adminServer.setStarted();
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void start(IServer server) {
        Runtime.getRuntime().addShutdownHook(new Thread(server::stop));
        server.start();
    }

    private static IServer getServer(String scope) {
        Serializable texterraFactory = TexterraHolder::get;
        return new TexterraRESTServer(scope, (Function<String, Texterra>)((Object)texterraFactory));
    }

    private static void executeStop(Namespace namespace) {
        try {
            ServerManager.stop(ConfigurationHelper.getScope(namespace));
            System.out.println("Server is stopped.");
        }
        catch (Exception e) {
            System.err.println("Failed to stop server.");
        }
    }

    private static void executeStatus(Namespace namespace) {
        TexterraAdminServer.Status status = ServerCLI.getStatus(namespace);
        System.out.println(status.getDescription());
    }

    private static TexterraAdminServer.Status getStatus(Namespace namespace) {
        return ServerManager.getStatus(ConfigurationHelper.getScope(namespace));
    }
}

