/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.cli;

import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;
import ru.ispras.texterra.cli.Command;
import ru.ispras.texterra.cli.ConfigurationHelper;
import ru.ispras.texterra.cli.SubcommandHelper;
import ru.ispras.texterra.cli.server.ServerCLI;

public final class TexterraCLI {
    private static final String COMMAND = "COMMAND";

    public static void main(String[] args) {
        ArgumentParser parser = TexterraCLI.exposeCli();
        if (args.length == 0) {
            parser.printHelp();
            return;
        }
        try {
            Namespace namespace = parser.parseArgs(args);
            TexterraCLI.execute(namespace);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return;
        }
    }

    private static ArgumentParser exposeCli() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)TexterraCLI.class.getName(), (boolean)true).description("Texterra command line");
        ConfigurationHelper.exposeOnCli(parser);
        Subparsers subparsers = parser.addSubparsers().dest(COMMAND).metavar(COMMAND).title("available commands");
        ServerCLI.exposeOnCli(SubcommandHelper.add(subparsers, Command.server));
        return parser;
    }

    private static void execute(Namespace namespace) {
        ConfigurationHelper.copyToSystemProperties(namespace);
        Command command = Command.valueOf(namespace.getString(COMMAND));
        switch (command) {
            case server: {
                ServerCLI.execute(namespace);
                return;
            }
        }
        throw new IllegalStateException();
    }
}

