/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.utils.language;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfiguration;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.utils.language.ITexterraLanguage;
import ru.ispras.texterra.utils.language.TexterraLanguageException;

public class TexterraLanguagesManager {
    @ConfigurationProperty
    private static final String languageQualifiedNamesProperty = "languageQualifiedName";
    private static final Map<Locale, ITexterraLanguage> supportedLanguages = TexterraLanguagesManager.loadLanguages();

    private static final Map<Locale, ITexterraLanguage> loadLanguages() {
        List<String> languagesQualifiedNames = TexterraLanguagesManager.getLanguagesQualifiedNames();
        List<ITexterraLanguage> texterraLanguages = TexterraLanguagesManager.loadLanguages(languagesQualifiedNames);
        return TexterraLanguagesManager.fillLanguagesMap(texterraLanguages);
    }

    private static final List<String> getLanguagesQualifiedNames() {
        TexterraConfiguration configuration = TexterraConfigurationFactory.getConfiguration();
        return configuration.getAllProperties(TexterraLanguagesManager.class, languageQualifiedNamesProperty, TexterraConfiguration.NO_SCOPE);
    }

    private static final List<ITexterraLanguage> loadLanguages(List<String> languagesQuelifiedNames) {
        ArrayList<ITexterraLanguage> result = new ArrayList<ITexterraLanguage>(languagesQuelifiedNames.size());
        for (String languageQualifiedName : languagesQuelifiedNames) {
            result.add(TexterraLanguagesManager.loadLanguage(languageQualifiedName));
        }
        return result;
    }

    private static final ITexterraLanguage loadLanguage(String qualifiedName) {
        try {
            return Class.forName(qualifiedName).asSubclass(ITexterraLanguage.class).newInstance();
        }
        catch (ClassCastException e) {
            throw new TexterraLanguageException(qualifiedName + " is not Texterra language class");
        }
        catch (ClassNotFoundException e) {
            throw new TexterraLanguageException("There is no " + qualifiedName + " language in Texterra", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TexterraLanguageException(e);
        }
    }

    private static final Map<Locale, ITexterraLanguage> fillLanguagesMap(List<ITexterraLanguage> texterraLanguages) {
        HashMap<Locale, ITexterraLanguage> result = new HashMap<Locale, ITexterraLanguage>();
        for (ITexterraLanguage texterraLanguage : texterraLanguages) {
            result.put(texterraLanguage.getLocale(), texterraLanguage);
        }
        return result;
    }

    public static Set<ITexterraLanguage> getSupportedLanguages() {
        return ImmutableSet.copyOf(supportedLanguages.values());
    }

    public static ITexterraLanguage getTexterraLanguage(String languageTag) {
        Locale locale = Locale.forLanguageTag(languageTag);
        return TexterraLanguagesManager.getTexterraLanguage(locale);
    }

    public static ITexterraLanguage getTexterraLanguage(Locale locale) {
        ITexterraLanguage texterraLanguage = supportedLanguages.get(locale);
        if (texterraLanguage == null) {
            throw new TexterraLanguageException("Texterra doesn't support " + locale + " language");
        }
        return texterraLanguage;
    }

    public static boolean checkLanguageClass(LanguageClass languageClass, ITexterraLanguage texterraLanguage) {
        for (LanguageClass texterraLanguageClass : texterraLanguage.getLanguageClasses()) {
            if (!texterraLanguageClass.is(languageClass)) continue;
            return true;
        }
        return false;
    }

    public static enum LanguageClass {
        ALL(null),
        AGGLUTINATIVE(ALL),
        FLECTIVE(ALL);

        private LanguageClass parent;

        private LanguageClass(LanguageClass parent) {
            this.parent = parent;
        }

        public boolean is(LanguageClass other) {
            if (other == null) {
                return false;
            }
            LanguageClass languageClass = this;
            while (languageClass != null) {
                if (other == languageClass) {
                    return true;
                }
                languageClass = languageClass.parent;
            }
            return false;
        }
    }
}

