/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.utils;

import java.util.Collections;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.ISemanticContext;
import ru.ispras.texterra.core.nlp.datamodel.ISemanticContextValue;
import ru.ispras.texterra.core.nlp.datamodel.SemanticContextValue;
import ru.ispras.texterra.core.nlp.datamodel.ValuedAnnotation;

public final class SemanticContextUtils {
    public static <T extends ISemanticContextValue> ISemanticContext<T> getEmptyContext(INLPDocument doc) {
        return new EmptySemanticContext(doc);
    }

    static class EmptySemanticContext
    extends ValuedAnnotation<ISemanticContextValue>
    implements ISemanticContext<ISemanticContextValue> {
        private static final long serialVersionUID = 7377197876634939308L;
        private static final ISemanticContextValue empty = new SemanticContextValue(Collections.emptyList());

        public EmptySemanticContext(IAnnotation other) {
            super(other, empty);
        }

        public EmptySemanticContext(INLPDocument doc, int start, int end) {
            super(doc, start, end, empty);
        }

        public EmptySemanticContext(INLPDocument doc) {
            super(doc, empty);
        }

        public EmptySemanticContext(String text, int start, int end) {
            super(text, start, end, empty);
        }

        public EmptySemanticContext(String text) {
            super(text, empty);
        }
    }
}

