/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.utils;

import org.apache.commons.lang.Validate;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;

public final class AnnotationUtils {
    public static boolean contains(IAnnotation container, IAnnotation containment) {
        Validate.isTrue((boolean)container.getAnnotatedText().equals(containment.getAnnotatedText()));
        return containment.getStart() >= container.getStart() && containment.getEnd() <= container.getEnd();
    }

    public static int getLength(IAnnotation annotation) {
        return annotation.getEnd() - annotation.getStart();
    }

    public static boolean coincides(IAnnotation one, IAnnotation another) {
        Validate.isTrue((boolean)one.getAnnotatedText().equals(another.getAnnotatedText()));
        return one.getStart() == another.getStart() && one.getEnd() == another.getEnd();
    }
}

