/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.serializers.simple;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;
import org.simpleframework.xml.stream.Style;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.serializers.ISerializer;
import ru.ispras.texterra.core.nlp.serializers.simple.TexterraNLPStrategy;

public class SimpleSerializer
implements ISerializer {
    private static final int INDENTATION_SIZE = 4;
    protected final Serializer serializer;

    public SimpleSerializer(Map<Class<?>, Converter<?>> converters) {
        Registry registry = this.buildRegistry(converters);
        RegistryStrategy strategy = new RegistryStrategy(registry, (Strategy)new TexterraNLPStrategy());
        Format format = new Format(4, (Style)new HyphenStyle());
        this.serializer = new Persister((Strategy)strategy, format);
    }

    private Registry buildRegistry(Map<Class<?>, Converter<?>> converters) {
        try {
            Registry registry = new Registry();
            for (Map.Entry<Class<?>, Converter<?>> converter : converters.entrySet()) {
                registry.bind(converter.getKey(), converter.getValue());
            }
            return registry;
        }
        catch (Exception e) {
            throw new TexterraSystemException(e);
        }
    }

    @Override
    public void write(Object obj, OutputStream out) {
        try {
            this.serializer.write(obj, out);
        }
        catch (Exception e) {
            throw new TexterraSystemException(e);
        }
    }

    @Override
    public <T> T read(Class<T> c, InputStream in) {
        try {
            return (T)this.serializer.read(c, in);
        }
        catch (Exception e) {
            throw new TexterraSystemException(e);
        }
    }

    public static String getNormalizedString(String str) {
        return str.replaceAll("\r", " ");
    }
}

