/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.serializers;

import ru.ispras.modis.utils.config.validation.ConfigurationProperty;
import ru.ispras.texterra.core.configuration.TexterraConfigurationFactory;
import ru.ispras.texterra.core.exceptions.TexterraConfigException;
import ru.ispras.texterra.core.nlp.serializers.ISerializer;
import ru.ispras.texterra.core.nlp.serializers.ISerializerFactory;

public class ConfigurableSerializerFactory
implements ISerializerFactory {
    @ConfigurationProperty
    private static final String factoryClassProperty = "factoryClass";
    private static ConfigurableSerializerFactory instance;
    private final ISerializerFactory factory;

    public static synchronized ConfigurableSerializerFactory getInstance() {
        if (instance == null) {
            instance = new ConfigurableSerializerFactory();
        }
        return instance;
    }

    private ConfigurableSerializerFactory() {
        try {
            String factoryClass = TexterraConfigurationFactory.getConfiguration().getStringProperty(ConfigurableSerializerFactory.class, factoryClassProperty);
            Class<ISerializerFactory> c = Class.forName(factoryClass).asSubclass(ISerializerFactory.class);
            this.factory = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new TexterraConfigException(ConfigurableSerializerFactory.class, factoryClassProperty, "Could not find specified class.");
        }
        catch (ClassCastException e) {
            throw new TexterraConfigException(ConfigurableSerializerFactory.class, factoryClassProperty, "Specified class should be subclass of ISerializerFactory.");
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TexterraConfigException(ConfigurableSerializerFactory.class, factoryClassProperty, "Specified class could not be instantiated.");
        }
    }

    @Override
    public ISerializer create() {
        return this.factory.create();
    }
}

