/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datasets.common.synTagRus;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import ru.ispras.modis.utils.concurrent.StreamProcessor;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTagFactory;
import ru.ispras.texterra.core.nlp.datasets.IDatasetReader;
import ru.ispras.texterra.core.nlp.datasets.common.synTagRus.SynTagRusPerSentenceFileParser;

public class SynTagRusPerSentenceDatasetParser
implements IDatasetReader {
    private final File base;
    private final IPOSTagFactory<?> posTagFactory;

    public SynTagRusPerSentenceDatasetParser(File corpusRoot, IPOSTagFactory<?> posTagFactory) {
        this.base = corpusRoot;
        this.posTagFactory = posTagFactory;
    }

    @Override
    public Iterable<INLPDocument> read() {
        Collection files = FileUtils.listFiles((File)this.base, (String[])new String[]{"tgt"}, (boolean)true);
        return new NestedIterable<INLPDocument>(new StreamProcessor().transform((Iterable)files, (StreamProcessor.IElementTransformer)new StreamProcessor.IElementTransformer<File, Iterable<INLPDocument>>(){

            public Iterable<INLPDocument> transformElement(File file) {
                return new SynTagRusPerSentenceFileParser(file, SynTagRusPerSentenceDatasetParser.this.posTagFactory).read();
            }
        }));
    }

    private static class NestedIterable<A>
    implements Iterable<A> {
        private final Iterable<? extends Iterable<A>> nestedIterable;

        public NestedIterable(Iterable<? extends Iterable<A>> nestedIterable) {
            this.nestedIterable = nestedIterable;
        }

        @Override
        public Iterator<A> iterator() {
            return new NestedIterator(this.nestedIterable.iterator());
        }
    }

    private static class NestedIterator<A>
    implements Iterator<A> {
        private final Iterator<? extends Iterable<A>> ambientIterator;
        private Iterator<A> currentIterator;

        public NestedIterator(Iterator<? extends Iterable<A>> ambientIterator) {
            this.ambientIterator = ambientIterator;
            this.currentIterator = this.ambientIterator.hasNext() ? this.ambientIterator.next().iterator() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (!this.ambientIterator.hasNext()) {
                return false;
            }
            this.currentIterator = this.ambientIterator.next().iterator();
            return this.hasNext();
        }

        @Override
        public A next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

