/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datasets;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import ru.ispras.modis.utils.concurrent.StreamProcessor;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datasets.IDatasetReader;
import ru.ispras.texterra.core.nlp.serializers.ConfigurableSerializerFactory;
import ru.ispras.texterra.core.nlp.serializers.ISerializer;
import ru.ispras.texterra.core.nlp.serializers.SerializationHelper;

public class SerializationDatasetReaderWrapper
implements IDatasetReader {
    private final IDatasetReader reader;
    private final ISerializer serializer;
    private final IFileNameGenerator fileNameGenerator;
    private final File baseDir;

    public SerializationDatasetReaderWrapper(IDatasetReader reader, ISerializer serializer, File baseDir, IFileNameGenerator fileNameGenerator) {
        this.reader = reader;
        this.serializer = serializer;
        this.baseDir = baseDir;
        this.fileNameGenerator = fileNameGenerator;
    }

    @Deprecated
    public SerializationDatasetReaderWrapper(IDatasetReader reader, File baseDir) {
        this(reader, ConfigurableSerializerFactory.getInstance().create(), baseDir, new CounterFileNameGenerator("document-", "xml"));
    }

    @Override
    public Iterable<INLPDocument> read() {
        Iterable<INLPDocument> data = this.reader.read();
        return new StreamProcessor().transform(data, (StreamProcessor.IElementTransformer)new StreamProcessor.IElementTransformer<INLPDocument, INLPDocument>(){

            public INLPDocument transformElement(INLPDocument input) {
                try {
                    FileOutputStream os = new FileOutputStream(new File(SerializationDatasetReaderWrapper.this.baseDir, SerializationDatasetReaderWrapper.this.fileNameGenerator.generateName(input)));
                    SerializationHelper.write(SerializationDatasetReaderWrapper.this.serializer, (Object)input, os);
                    ((OutputStream)os).close();
                    return input;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static class CounterFileNameGenerator
    implements IFileNameGenerator {
        private final String prefix;
        private final String extension;
        private int counter;

        public CounterFileNameGenerator(String prefix, String extension) {
            this.prefix = prefix;
            this.extension = extension;
            this.counter = 0;
        }

        @Override
        public synchronized String generateName(INLPDocument doc) {
            return this.prefix + this.counter++ + '.' + this.extension;
        }
    }

    public static interface IFileNameGenerator {
        public String generateName(INLPDocument var1);
    }
}

