/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datasets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import ru.ispras.modis.utils.concurrent.StreamProcessor;
import ru.ispras.texterra.core.exceptions.TexterraSystemException;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocument;
import ru.ispras.texterra.core.nlp.datasets.IDatasetReader;

public class FromTextFilesDatasetReader
implements IDatasetReader {
    private final File inputDir;
    private final FilenameFilter filter;

    public FromTextFilesDatasetReader(File inputDir, FilenameFilter filter) {
        this.inputDir = inputDir;
        this.filter = filter;
    }

    public FromTextFilesDatasetReader(File inputDir) {
        this(inputDir, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        });
    }

    @Override
    public Iterable<INLPDocument> read() {
        return new StreamProcessor().transform(Arrays.asList(this.inputDir.listFiles(this.filter)), (StreamProcessor.IElementTransformer)new StreamProcessor.IElementTransformer<File, INLPDocument>(){

            public INLPDocument transformElement(File input) {
                try {
                    return new NLPDocument(IOUtils.toString((InputStream)new FileInputStream(input)));
                }
                catch (IOException e) {
                    throw new TexterraSystemException(e);
                }
            }
        });
    }
}

