/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.syntax;

import org.simpleframework.xml.Element;
import org.simpleframework.xml.Text;
import ru.ispras.texterra.core.nlp.datamodel.IToken;
import ru.ispras.texterra.core.nlp.datamodel.syntax.ISyntaxRelationValue;

public class SyntaxRelationValue
implements ISyntaxRelationValue {
    private static final long serialVersionUID = -2166579201650089340L;
    @Element(name="parent-token")
    private final IToken parent;
    private final String relationType;

    private SyntaxRelationValue(@Element(name="parent-token") IToken parent, @Element(name="relation-type") RelationType relationType) {
        this.parent = parent;
        this.relationType = relationType.value;
    }

    @Element(name="relation-type")
    private RelationType getRelationType4Simple() {
        return new RelationType(this.relationType);
    }

    public SyntaxRelationValue(IToken parent, String relationType) {
        this.parent = parent;
        this.relationType = relationType;
    }

    @Override
    public boolean hasParentToken() {
        return this.parent != null;
    }

    @Override
    public IToken getParentToken() {
        return this.parent;
    }

    @Override
    public String getRelationType() {
        return this.relationType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.relationType == null ? 0 : this.relationType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntaxRelationValue)) {
            return false;
        }
        SyntaxRelationValue other = (SyntaxRelationValue)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.relationType == null ? other.relationType != null : !this.relationType.equals(other.relationType));
    }

    public String toString() {
        return "SyntaxRelation [" + (this.hasParentToken() ? "parent=[" + (String)this.parent.getValue() + ", " + this.parent.getStart() + "-" + this.parent.getEnd() + "]," : "NULL") + " relationType=" + this.relationType + "]";
    }

    private static final class RelationType {
        @Text
        private final String value;

        public RelationType(@Text String value) {
            this.value = value;
        }
    }
}

