/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.storage.StorageUtils;

public class InstancesSortedStorage<T>
implements Serializable {
    private static final long serialVersionUID = 3514001571998970827L;
    private final Map<Class<? extends T>, List<T>> class2instances;
    private final Comparator<T> comparator;

    private InstancesSortedStorage(Map<Class<? extends T>, List<T>> class2instances, Comparator<T> comparator) {
        this.class2instances = this.copyClass2Instances(class2instances);
        this.comparator = comparator;
    }

    private Map<Class<? extends T>, List<T>> copyClass2Instances(Map<Class<? extends T>, List<T>> class2instances) {
        HashMap<Class<T>, List<T>> copy = new HashMap<Class<T>, List<T>>();
        for (Map.Entry<Class<T>, List<T>> entry : class2instances.entrySet()) {
            copy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }

    public InstancesSortedStorage(InstancesSortedStorage<T> other) {
        this(other.class2instances, other.comparator);
    }

    public InstancesSortedStorage(Comparator<T> comparator) {
        this(new HashMap<Class<? extends T>, List<T>>(), comparator);
    }

    public void putAll(Collection<? extends T> newInstances) {
        List<T> list;
        for (T elem : newInstances) {
            Class<?> clazz = elem.getClass();
            if (this.class2instances.containsKey(clazz)) {
                list = this.class2instances.get(clazz);
                list.add(elem);
                continue;
            }
            list = new ArrayList<T>();
            list.add(elem);
            this.class2instances.put(clazz, list);
        }
        Collection<Class<T>> classesForSorting = StorageUtils.getParticipatingClasses(newInstances);
        for (Class<T> clazz : classesForSorting) {
            list = this.class2instances.get(clazz);
            Collections.sort(list, this.comparator);
        }
    }

    public <S extends T> List<S> get(Class<S> c) {
        List<T> instances = this.class2instances.get(c);
        if (instances != null) {
            return instances;
        }
        return Collections.emptyList();
    }

    public <S extends T> List<S> remove(Class<S> c) {
        return this.class2instances.remove(c);
    }

    public boolean contains(Class<? extends T> c) {
        return this.class2instances.containsKey(c);
    }

    public Set<Class<? extends T>> keySet() {
        return Collections.unmodifiableSet(this.class2instances.keySet());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.class2instances == null ? 0 : this.class2instances.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancesSortedStorage)) {
            return false;
        }
        InstancesSortedStorage other = (InstancesSortedStorage)obj;
        return !(this.class2instances == null ? other.class2instances != null : !this.class2instances.equals(other.class2instances));
    }
}

