/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.storage.InstancesSortedStorage;
import ru.ispras.texterra.core.nlp.datamodel.storage.StorageUtils;
import ru.ispras.texterra.core.nlp.datamodel.storage.StoredClassesHierarchy;

public class HierarchicInstancesSortedStorage<R>
implements Serializable {
    private static final long serialVersionUID = 8144590740734302888L;
    private final InstancesSortedStorage<R> storage;
    private StoredClassesHierarchy<R> hierarchy;
    private final Class<R> rootClass;
    private final Comparator<R> comparator;

    public HierarchicInstancesSortedStorage(Class<R> rootClass, Comparator<R> comparator) {
        this.comparator = comparator;
        this.rootClass = rootClass;
        this.storage = new InstancesSortedStorage<R>(comparator);
        this.hierarchy = new StoredClassesHierarchy<R>(rootClass);
    }

    public HierarchicInstancesSortedStorage(HierarchicInstancesSortedStorage<R> storage) {
        this.comparator = storage.comparator;
        this.rootClass = storage.rootClass;
        this.storage = new InstancesSortedStorage<R>(storage.storage);
        this.hierarchy = new StoredClassesHierarchy<R>(storage.hierarchy);
    }

    public void addInstances(Collection<? extends R> newcomers) {
        this.storage.putAll(newcomers);
        this.hierarchy.store(StorageUtils.getParticipatingClasses(newcomers));
    }

    public <S extends R> List<S> getInstances(Class<S> clazz) {
        Set<Class<S>> subclasses = this.hierarchy.getClassesAssignableFrom(clazz);
        if (subclasses.size() == 1) {
            return new ArrayList<S>(this.storage.get(subclasses.iterator().next()));
        }
        ArrayList<S> result = new ArrayList<S>();
        for (Class<S> subClass : subclasses) {
            result.addAll(this.storage.get(subClass));
        }
        Collections.sort(result, this.comparator);
        return result;
    }

    public <S extends R> List<S> removeInstances(Class<S> clazz) {
        ArrayList<S> result = new ArrayList<S>();
        for (Class<S> subClass : this.hierarchy.getClassesAssignableFrom(clazz)) {
            if (!this.storage.contains(subClass)) continue;
            result.addAll(this.storage.remove(subClass));
        }
        this.hierarchy = new StoredClassesHierarchy<R>(this.rootClass);
        this.hierarchy.store(this.storage.keySet());
        Collections.sort(result, this.comparator);
        return result;
    }

    public <S extends R> boolean hasInstances(Class<S> clazz) {
        for (Class<S> subClass : this.hierarchy.getClassesAssignableFrom(clazz)) {
            if (!this.storage.contains(subClass)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends R>> getInstancesClasses() {
        return this.storage.keySet();
    }

    public Class<R> getRootClass() {
        return this.rootClass;
    }

    public Comparator<R> getComparator() {
        return this.comparator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootClass == null ? 0 : this.rootClass.hashCode());
        result = 31 * result + (this.storage == null ? 0 : this.storage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchicInstancesSortedStorage)) {
            return false;
        }
        HierarchicInstancesSortedStorage other = (HierarchicInstancesSortedStorage)obj;
        if (this.rootClass == null ? other.rootClass != null : !this.rootClass.equals(other.rootClass)) {
            return false;
        }
        return !(this.storage == null ? other.storage != null : !this.storage.equals(other.storage));
    }
}

