/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.relations;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.AnnotationRelations;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;

public class AtRightAnnotationRelationCacheBuilder
implements IAnnotationRelationCacheBuilder {
    private static final IAnnotationRelation relation = AnnotationRelations.atRight();

    @Override
    public Map<IAnnotation, Collection<? extends IAnnotation>> buildCache(List<? extends IAnnotation> baseAnnotations, List<? extends IAnnotation> targetAnnotations) {
        HashMap<IAnnotation, Collection<? extends IAnnotation>> result = new HashMap<IAnnotation, Collection<? extends IAnnotation>>();
        int fromIndex = 0;
        for (IAnnotation iAnnotation : baseAnnotations) {
            while (fromIndex < targetAnnotations.size() && !relation.areInRelation(iAnnotation, targetAnnotations.get(fromIndex))) {
                ++fromIndex;
            }
            result.put(iAnnotation, targetAnnotations.subList(fromIndex, targetAnnotations.size()));
        }
        return result;
    }

    @Override
    public IAnnotationRelation getRelation() {
        return relation;
    }
}

