/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.relations;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.AnnotationRelations;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;

public class AtLeftAnnotationRelationCacheBuilder
implements IAnnotationRelationCacheBuilder {
    private static final IAnnotationRelation relation = AnnotationRelations.atLeft();

    @Override
    public Map<IAnnotation, Collection<? extends IAnnotation>> buildCache(List<? extends IAnnotation> baseAnnotations, List<? extends IAnnotation> targetAnnotations) {
        HashMap<IAnnotation, Collection<? extends IAnnotation>> result = new HashMap<IAnnotation, Collection<? extends IAnnotation>>();
        int upToIndex = 0;
        for (IAnnotation iAnnotation : baseAnnotations) {
            while (upToIndex < targetAnnotations.size() && relation.areInRelation(iAnnotation, targetAnnotations.get(upToIndex))) {
                ++upToIndex;
            }
            result.put(iAnnotation, targetAnnotations.subList(0, upToIndex));
        }
        return result;
    }

    @Override
    public IAnnotationRelation getRelation() {
        return relation;
    }
}

