/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.relations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelationCacheBuilder;

public final class AnnotationRelationCacheBuilder
implements IAnnotationRelationCacheBuilder {
    private final IAnnotationRelation relation;

    public AnnotationRelationCacheBuilder(IAnnotationRelation relation) {
        this.relation = relation;
    }

    @Override
    public Map<IAnnotation, Collection<? extends IAnnotation>> buildCache(List<? extends IAnnotation> baseAnnotations, List<? extends IAnnotation> targetAnnotations) {
        HashMap<IAnnotation, Collection<? extends IAnnotation>> cache = new HashMap<IAnnotation, Collection<? extends IAnnotation>>();
        for (IAnnotation iAnnotation : baseAnnotations) {
            ArrayList<IAnnotation> inRelationAnnotations = new ArrayList<IAnnotation>();
            for (IAnnotation iAnnotation2 : targetAnnotations) {
                if (!this.relation.areInRelation(iAnnotation, iAnnotation2)) continue;
                inRelationAnnotations.add(iAnnotation2);
            }
            cache.put(iAnnotation, inRelationAnnotations);
        }
        return cache;
    }

    @Override
    public IAnnotationRelation getRelation() {
        return this.relation;
    }
}

