/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.pos.morph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTagFactory;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.MorphProperties;
import ru.ispras.texterra.core.nlp.datamodel.pos.morph.characters.IMorphCharacter;

public class MorphPropertiesTagFactory
implements IPOSTagFactory<MorphProperties> {
    private static final long serialVersionUID = -838838713347346642L;
    private final IPOSTagFactory<?> posTagFactory;
    private final Map<String, IMorphCharacter> value2morphCharacter;

    @SafeVarargs
    public MorphPropertiesTagFactory(IPOSTagFactory<?> posTagFactory, Class<? extends IMorphCharacter> ... morphCharacterEnums) {
        this.posTagFactory = posTagFactory;
        this.value2morphCharacter = new HashMap<String, IMorphCharacter>();
        for (Class<? extends IMorphCharacter> morphCharacterClass : morphCharacterEnums) {
            if (!morphCharacterClass.isEnum()) {
                throw new IllegalArgumentException();
            }
            for (IMorphCharacter possibleMorphCharacter : morphCharacterClass.getEnumConstants()) {
                this.value2morphCharacter.put(possibleMorphCharacter.getValue(), possibleMorphCharacter);
            }
        }
    }

    @Override
    public MorphProperties getPOSTag(String tag) {
        String[] splittedTag = tag.split("[\\s|_]");
        Object posTag = this.posTagFactory.getPOSTag(splittedTag[0]);
        ArrayList<IMorphCharacter> morphCharacters = new ArrayList<IMorphCharacter>(splittedTag.length - 1);
        for (int i = 1; i < splittedTag.length; ++i) {
            IMorphCharacter morphCharacter = this.parseMorphCharacter(splittedTag[i]);
            if (morphCharacter == null) continue;
            morphCharacters.add(morphCharacter);
        }
        MorphProperties result = new MorphProperties((IPOSTag)posTag, (Collection<IMorphCharacter>)morphCharacters);
        return result;
    }

    private IMorphCharacter parseMorphCharacter(String tag) {
        return this.value2morphCharacter.get(tag);
    }
}

