/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.pos.kaist;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;

public enum KAISTPOSTag implements IPOSTag
{
    OTHER,
    SP,
    SF,
    SL,
    SR,
    II,
    MA,
    PA,
    NP,
    PV,
    NN,
    NB,
    NC,
    NQ,
    F;

    private static final Set<KAISTPOSTag> adjectives;
    private static final Set<KAISTPOSTag> adverbs;
    private static final Set<KAISTPOSTag> punctuation;
    private static final Set<KAISTPOSTag> nouns;
    private static final Set<KAISTPOSTag> verbs;

    @Override
    public boolean isAdjective() {
        return adjectives.contains(this);
    }

    @Override
    public boolean isAdverb() {
        return adverbs.contains(this);
    }

    @Override
    public boolean isNoun() {
        return nouns.contains(this);
    }

    @Override
    public boolean isPunctuation() {
        return punctuation.contains(this);
    }

    @Override
    public boolean isVerb() {
        return verbs.contains(this);
    }

    @Override
    public boolean isDeterminer() {
        return false;
    }

    @Override
    public boolean isNumeral() {
        return false;
    }

    @Override
    public String getTag() {
        return this.toString();
    }

    static {
        adjectives = new HashSet<KAISTPOSTag>(Arrays.asList(PA));
        adverbs = new HashSet<KAISTPOSTag>(Arrays.asList(MA));
        punctuation = new HashSet<KAISTPOSTag>(Arrays.asList(SP, SF, SL, SR));
        nouns = new HashSet<KAISTPOSTag>(Arrays.asList(NN, NB, NC, NQ, F, OTHER));
        verbs = new HashSet<KAISTPOSTag>(Arrays.asList(PV));
    }
}

