/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel.pos;

import ru.ispras.texterra.core.nlp.datamodel.pos.IPOSTag;

public enum GeneralPOSTag implements IPOSTag
{
    Adverb,
    Adjective,
    Noun,
    Verb,
    Determiner,
    Punctuation,
    Other;


    public static GeneralPOSTag getGeneralTag(IPOSTag posTag) {
        if (posTag.isAdjective()) {
            return Adjective;
        }
        if (posTag.isAdverb()) {
            return Adverb;
        }
        if (posTag.isNoun()) {
            return Noun;
        }
        if (posTag.isVerb()) {
            return Verb;
        }
        if (posTag.isDeterminer()) {
            return Determiner;
        }
        return Other;
    }

    @Override
    public boolean isAdverb() {
        return this.equals(Adverb);
    }

    @Override
    public boolean isAdjective() {
        return this.equals(Adjective);
    }

    @Override
    public boolean isNoun() {
        return this.equals(Noun);
    }

    @Override
    public boolean isVerb() {
        return this.equals(Verb);
    }

    @Override
    public boolean isPunctuation() {
        return this.equals(Punctuation);
    }

    @Override
    public boolean isDeterminer() {
        return this.equals(Determiner);
    }

    @Override
    public boolean isNumeral() {
        return false;
    }

    @Override
    public String getTag() {
        return this.toString();
    }
}

