/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import org.simpleframework.xml.Element;
import ru.ispras.texterra.core.nlp.datamodel.Annotation;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;

public class ValuedAnnotation<V>
extends Annotation
implements IValuedAnnotation<V> {
    private static final long serialVersionUID = 61786496020688490L;
    @Element(name="value")
    protected final V value;

    protected ValuedAnnotation(@Element(name="annotatedText") String text, @Element(name="start") int start, @Element(name="end") int end, @Element(name="value") V value) {
        super(text, start, end);
        assert (value != null);
        this.value = value;
    }

    protected ValuedAnnotation(String text, V value) {
        super(text);
        assert (value != null);
        this.value = value;
    }

    protected ValuedAnnotation(IAnnotation other, V value) {
        super(other);
        assert (value != null);
        this.value = value;
    }

    protected ValuedAnnotation(INLPDocument doc, int start, int end, V value) {
        super(doc, start, end);
        assert (value != null);
        this.value = value;
    }

    protected ValuedAnnotation(INLPDocument doc, V value) {
        super(doc);
        assert (value != null);
        this.value = value;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IValuedAnnotation)) {
            return false;
        }
        IValuedAnnotation other = (IValuedAnnotation)obj;
        return !(this.value == null ? other.getValue() != null : !this.value.equals(other.getValue()));
    }

    @Override
    public String toString() {
        String parent = super.toString();
        StringBuilder builder = new StringBuilder(parent.substring(0, parent.length() - 1));
        builder.append(", value=").append(this.value).append("]");
        return builder.toString();
    }
}

