/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.IValuedAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.Language;
import ru.ispras.texterra.core.nlp.datamodel.NLPDocumentWithAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.CoinsidesAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainedAnnotationRelation;
import ru.ispras.texterra.core.nlp.datamodel.relations.ContainsAnnotationRelation;
import ru.ispras.texterra.utils.language.ITexterraLanguage;

public class NLPDocumentHelper {
    public static final CoinsidesAnnotationRelation COINSIDES_RELATION = new CoinsidesAnnotationRelation();
    public static final ContainsAnnotationRelation CONTAINS_RELATION = new ContainsAnnotationRelation();
    public static final ContainedAnnotationRelation CONTAINED_RELATION = new ContainedAnnotationRelation();

    public static <T extends IAnnotation> List<T> getContainerAnnotations(INLPDocument doc, IAnnotation containedAnnotation, Class<T> annotationClass) {
        return doc.getInRelationAnnotations(containedAnnotation, CONTAINED_RELATION, annotationClass);
    }

    public static <T extends IAnnotation> List<T> getContainedAnnotations(INLPDocument doc, IAnnotation container, Class<T> annotationClass) {
        return doc.getInRelationAnnotations(container, CONTAINS_RELATION, annotationClass);
    }

    public static <CA extends IAnnotation> CA getContainerAnnotation(INLPDocument document, IAnnotation annotation, Class<CA> containerType) {
        List<CA> containers = document.getInRelationAnnotations(annotation, CONTAINED_RELATION, containerType);
        if (containers.size() != 1) {
            throw new IllegalStateException(String.format("Document should contain exactly 1 (not %d) %s containing %s.", containers.size(), containerType.getName(), annotation));
        }
        return (CA)((IAnnotation)containers.get(0));
    }

    public static <TA extends IAnnotation> TA getCoincidingAnnotation(INLPDocument document, IAnnotation annotation, Class<TA> targetType) {
        Optional<TA> coinciding = NLPDocumentHelper.getOptionalCoincidingAnnotation(document, annotation, targetType);
        return (TA)((IAnnotation)coinciding.orElseThrow(() -> new IllegalStateException(String.format("There are no %s coinciding annotations to %s.", targetType.getName(), annotation))));
    }

    public static <TA extends IAnnotation> Optional<TA> getOptionalCoincidingAnnotation(INLPDocument doc, IAnnotation annotation, Class<TA> targetType) {
        List<TA> targets = doc.getInRelationAnnotations(annotation, COINSIDES_RELATION, targetType);
        if (targets.size() > 1) {
            throw new IllegalStateException(String.format("Document should contain not more than 1 (not %d) %s coinciding to %s.", targets.size(), targetType.getName(), annotation));
        }
        return targets.size() == 1 ? Optional.of(targets.get(0)) : Optional.empty();
    }

    public static <A extends IAnnotation> List<NLPDocumentWithAnnotation<A>> getDocumentsWithAnnotations(INLPDocument document, List<A> annotations) {
        ArrayList<NLPDocumentWithAnnotation<A>> result = new ArrayList<NLPDocumentWithAnnotation<A>>();
        for (IAnnotation annotation : annotations) {
            result.add(new NLPDocumentWithAnnotation<IAnnotation>(document, annotation));
        }
        return result;
    }

    public static <TA extends IAnnotation> TA getAnnotation(INLPDocument document, Class<TA> targetType) {
        List<TA> targets = document.getAnnotations(targetType);
        if (targets.size() != 1) {
            throw new IllegalStateException(String.format("Document should contain exactly 1 (not %d) %s annotations.", targets.size(), targetType.getName()));
        }
        return (TA)((IAnnotation)targets.get(0));
    }

    public static ITexterraLanguage getDocumentLanguage(INLPDocument doc) {
        List<Language> languages = doc.getAnnotations(Language.class);
        if (languages.size() != 1) {
            throw new IllegalStateException("NLP document has no or more than one language");
        }
        return (ITexterraLanguage)((Language)languages.iterator().next()).getValue();
    }

    public static String getDocumentSnippet(INLPDocument doc, int maxLength) {
        String text = doc.getText();
        if (text.length() <= maxLength) {
            return text;
        }
        if (maxLength >= 21) {
            int length = (maxLength - 5) / 2;
            StringBuilder sb = new StringBuilder(maxLength);
            sb.append(text.substring(0, length));
            sb.append("<...>");
            sb.append(text.substring(text.length() - length));
            return sb.toString();
        }
        return text.substring(0, maxLength);
    }

    public static <V, A extends IValuedAnnotation<V>> List<V> getValues(List<A> annotations) {
        return annotations.stream().map(a -> a.getValue()).collect(Collectors.toList());
    }
}

