/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import ru.ispras.modis.utils.collections.MapUtils;
import ru.ispras.texterra.core.common.concept.Concept;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.ValuedAnnotation;

public class MeaningPhrase
extends ValuedAnnotation<MeaningsWithCommonness> {
    private static final long serialVersionUID = -381614661547851850L;

    public MeaningPhrase(IAnnotation other, MeaningsWithCommonness value) {
        super(other, value);
    }

    public MeaningPhrase(INLPDocument doc, int start, int end, MeaningsWithCommonness value) {
        super(doc, start, end, value);
    }

    public MeaningPhrase(INLPDocument doc, MeaningsWithCommonness value) {
        super(doc, value);
    }

    public MeaningPhrase(@Element(name="annotatedText") String text, @Element(name="start") int start, @Element(name="end") int end, @Element(name="value") MeaningsWithCommonness value) {
        super(text, start, end, value);
    }

    public MeaningPhrase(String text, MeaningsWithCommonness value) {
        super(text, value);
    }

    public Set<Concept> getMeanings() {
        return ((MeaningsWithCommonness)this.value).getMeanings();
    }

    public List<Concept> getSortedMeanings() {
        return ((MeaningsWithCommonness)this.value).getSortedMeanings();
    }

    public double getMeaningCommonness(Concept meaning) {
        return ((MeaningsWithCommonness)this.value).getMeaningCommonness(meaning);
    }

    public static class MeaningsWithCommonness
    implements Serializable {
        private static final long serialVersionUID = -5179318126856900314L;
        @ElementMap
        private final Map<Concept, Double> meaningsWithCommonness;

        public MeaningsWithCommonness(@ElementMap(name="meaningsWithCommonness") Map<Concept, Double> meaningsWithCommonness) {
            this.meaningsWithCommonness = meaningsWithCommonness;
        }

        public Set<Concept> getMeanings() {
            return Collections.unmodifiableSet(this.meaningsWithCommonness.keySet());
        }

        public List<Concept> getSortedMeanings() {
            List sortedMeanings = MapUtils.getSortedByValueKeys(this.meaningsWithCommonness);
            Collections.reverse(sortedMeanings);
            return sortedMeanings;
        }

        public Map<Concept, Double> getMeaningsWithCommonness() {
            return Collections.unmodifiableMap(this.meaningsWithCommonness);
        }

        public double getMeaningCommonness(Concept meaning) {
            if (this.meaningsWithCommonness.containsKey(meaning)) {
                return this.meaningsWithCommonness.get(meaning);
            }
            return 0.0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.meaningsWithCommonness == null ? 0 : this.meaningsWithCommonness.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MeaningsWithCommonness)) {
                return false;
            }
            MeaningsWithCommonness other = (MeaningsWithCommonness)obj;
            return !(this.meaningsWithCommonness == null ? other.meaningsWithCommonness != null : !this.meaningsWithCommonness.equals(other.meaningsWithCommonness));
        }
    }
}

