/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.datamodel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.relations.IAnnotationRelation;

public interface INLPDocument {
    public INLPDocument withoutAnnotations();

    public INLPDocument withAnnotations(Collection<? extends IAnnotation> var1);

    public <T extends IAnnotation> boolean hasAnnotations(Class<T> var1);

    public <T extends IAnnotation> List<T> getAnnotations(Class<T> var1);

    public <T extends IAnnotation> List<T> getInRelationAnnotations(IAnnotation var1, IAnnotationRelation var2, Class<T> var3);

    public String getText();

    public Set<Class<? extends IAnnotation>> getAnnotationsTypes();

    public static final class AnnotationsComparator
    implements Comparator<IAnnotation>,
    Serializable {
        private static final long serialVersionUID = 7241303307451238943L;

        @Override
        public int compare(IAnnotation one, IAnnotation another) {
            int startCompare = Integer.compare(one.getStart(), another.getStart());
            if (startCompare != 0) {
                return startCompare;
            }
            return Integer.compare(one.getEnd(), another.getEnd());
        }
    }
}

