/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import ru.ispras.texterra.core.nlp.datamodel.ne.INamedEntity;

public final class NamedEntityGroup
implements Serializable {
    private static final long serialVersionUID = -6145091820760715565L;
    private final Set<INamedEntity> namedEntities;

    public NamedEntityGroup(Collection<INamedEntity> namedEntities) {
        Validate.notEmpty(namedEntities, (String)"Empty named entity group is not allowed.");
        this.namedEntities = new HashSet<INamedEntity>(namedEntities);
    }

    public NamedEntityGroup(INamedEntity ... namedEntities) {
        this(Arrays.asList(namedEntities));
    }

    public boolean contains(INamedEntity namedEntity) {
        return this.namedEntities.contains(namedEntity);
    }

    public String toString() {
        return "NamedEntityGroup [" + this.namedEntities + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.namedEntities.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedEntityGroup other = (NamedEntityGroup)obj;
        return this.namedEntities.equals(other.namedEntities);
    }
}

