/*
 * Decompiled with CFR 0.152.
 */
package ru.ispras.texterra.core.nlp.annotators.spelling;

import java.util.Collection;
import java.util.LinkedList;
import ru.ispras.modis.utils.collections.PackedStringObjectMap;
import ru.ispras.texterra.core.nlp.annotators.IAnnotator;
import ru.ispras.texterra.core.nlp.datamodel.IAnnotation;
import ru.ispras.texterra.core.nlp.datamodel.INLPDocument;
import ru.ispras.texterra.core.nlp.datamodel.spelling.Misspelling;
import ru.ispras.texterra.core.nlp.datamodel.spelling.SpellingSuggestion;

public class SlangSuggester
implements IAnnotator<SpellingSuggestion> {
    private final PackedStringObjectMap<String> slangDict;

    public SlangSuggester(PackedStringObjectMap<String> slangDict) {
        this.slangDict = slangDict;
    }

    @Override
    public Collection<SpellingSuggestion> annotate(INLPDocument doc) {
        LinkedList<SpellingSuggestion> res = new LinkedList<SpellingSuggestion>();
        for (Misspelling misspelling : doc.getAnnotations(Misspelling.class)) {
            String slangSuggestion = (String)this.slangDict.get(misspelling.getText());
            if (slangSuggestion == null) continue;
            res.add(new SpellingSuggestion((IAnnotation)misspelling, slangSuggestion));
        }
        return res;
    }
}

